/*

	working:
		Alien Syndrome
		Altered Beast
		Aurail: some graphics glitches
		Dynamite Dux: some graphics glitches
		Flash Point: dipswitches are wrong
		Golden Axe
		Passing Shot: wrong screen orientation
		SDI: I think it needs the analog controls mapped
		Shinobi
		Tetris
		Time Scanner: wrong screen orientation; transparency and sprite glitches
		Tough Turf: background glitches
		Wonderboy 3 - Monster Lair
		Wrestle War: some sprite glitches, wrong orientation

	not really working:
		Alex Kidd: no sprites, messed up graphics
		Alien Storm: black screen
		E-Swat: black screen
		Heavyweight Champ: messed up graphics
		Major League: missing sprites?
		Quartet 2: no sprites, messed up background


	other System16/18 games, not yet described in this file:
		Hang-on
		Space Harrier
		Moonwalker
		Outrun
		Super Hangon
		Shadow Dancer
*/

#define SYS16_CREDITS \
	"Thierry Lescot & Nao (Hardware Info)\n" \
	"Mirko Buffoni (MAME driver)\n" \
	"Phil Stroffolino"

#include "driver.h"
#include "vidhrdw/generic.h"
#include "sndhrdw/2151intf.h"


/***************************************************************************/

extern int sys16_vh_start( void );
extern void sys16_vh_stop( void );
extern void sys16_vh_screenrefresh(struct osd_bitmap *bitmap,int full_refresh);

/* video driver constants (vary with game) */
extern int sys16_spritesystem;
extern int sys16_sprxoffset;
extern int *sys16_obj_bank;
void (* sys16_update_proc)( void );

/* video driver registers */
extern int sys16_refreshenable;
extern int sys16_tile_bank0;
extern int sys16_tile_bank1;
extern int sys16_bg_scrollx, sys16_bg_scrolly;
extern int sys16_bg_page[4];
extern int sys16_fg_scrollx, sys16_fg_scrolly;
extern int sys16_fg_page[4];

/* video driver has access to these memory regions */
unsigned char *sys16_tileram;
unsigned char *sys16_textram;
unsigned char *sys16_spriteram;

/* other memory regions */
static unsigned char *sys16_ROM;
static unsigned char *sys16_workingram;
static unsigned char *sys16_extraram;
static unsigned char *sys16_extraram2;
static unsigned char *sys16_extraram3;

/* shared memory */
static int mirror1_hi_addr;
static int mirror1_lo_addr;
static int mirror1_word;

static int mirror2_hi_addr;
static int mirror2_lo_addr;
static int mirror2_word;

static int mirror3_hi_addr;
static int mirror3_lo_addr;
static int mirror3_word;

/***************************************************************************/

#define MWA_PALETTERAM	sys16_paletteram_w, &paletteram
#define MRA_PALETTERAM	paletteram_word_r

#define MRA_WORKINGRAM	MRA_BANK1
#define MWA_WORKINGRAM	MWA_BANK1,&sys16_workingram

#define MRA_SPRITERAM	MRA_BANK2
#define MWA_SPRITERAM	MWA_BANK2,&sys16_spriteram

#define MRA_TILERAM		MRA_BANK3
#define MWA_TILERAM		MWA_BANK3,&sys16_tileram

#define MRA_TEXTRAM		MRA_BANK4
#define MWA_TEXTRAM		MWA_BANK4,&sys16_textram

#define MRA_EXTRAM		MRA_BANK5
#define MWA_EXTRAM		MWA_BANK5,&sys16_extraram

#define MRA_EXTRAM2		MRA_BANK6
#define MWA_EXTRAM2		MWA_BANK6,&sys16_extraram2

#define MRA_EXTRAM3		MRA_BANK7
#define MWA_EXTRAM3		MWA_BANK7,&sys16_extraram3

/****************************************************************************

Some System16 games need mirrored addresses.  In MAME this presents some
difficulties, because memory read/write handlers for 68000 games are
word-based.  The following private functions make supporting mirrored
bytes easier.

****************************************************************************/

static void mirror1_w( int offset, int data ){
	if( (data&0xff000000)==0 ){
		if( mirror1_hi_addr )
			cpu_writemem24( mirror1_hi_addr, (data>>8)&0xff );
		else
			mirror1_word = (mirror1_word&0x00ff) | (data&0xff00);
	}

	if( (data&0x00ff0000)==0 ){
		if( mirror1_lo_addr )
			cpu_writemem24( mirror1_lo_addr, data&0xff );
		else
			mirror1_word = (mirror1_word&0xff00) | (data&0xff);
	}
}

static int mirror1_r( int offset ){
	int data = mirror1_word;
	if( mirror1_hi_addr ) data |= cpu_readmem24( mirror1_hi_addr )<<8;
	if( mirror1_lo_addr ) data |= cpu_readmem24( mirror1_lo_addr );

	if( data!= (input_port_0_r(offset) << 8) + input_port_1_r(offset) ){
		/*if( errorlog ) fprintf( errorlog, "bad\n" );*/
	}

	return data;
}

static void define_mirror1( int hi_addr, int lo_addr ){
	mirror1_word = 0;
	mirror1_hi_addr = hi_addr;
	mirror1_lo_addr = lo_addr;
}

static void mirror2_w( int offset, int data ){
	if( (data&0xff000000)==0 ){
		if( mirror2_hi_addr )
			cpu_writemem24( mirror2_hi_addr, (data>>8)&0xff );
		else
			mirror2_word = (mirror2_word&0x00ff) | (data&0xff00);
	}

	if( (data&0x00ff0000)==0 ){
		if( mirror2_lo_addr )
			cpu_writemem24( mirror2_lo_addr, data&0xff );
		else
			mirror2_word = (mirror2_word&0xff00) | (data&0xff);
	}
}

static int mirror2_r( int offset ){
	int data = mirror2_word;
	if( mirror2_hi_addr ) data |= cpu_readmem24( mirror2_hi_addr )<<8;
	if( mirror2_lo_addr ) data |= cpu_readmem24( mirror2_lo_addr );

	if( data!= (input_port_0_r(offset) << 8) + input_port_1_r(offset) ){
		/*if( errorlog ) fprintf( errorlog, "bad\n" );*/
	}

	return data;
}

static void define_mirror2( int hi_addr, int lo_addr ){
	mirror2_word = 0;
	mirror2_hi_addr = hi_addr;
	mirror2_lo_addr = lo_addr;
}

static void mirror3_w( int offset, int data ){
	if( (data&0xff000000)==0 ){
		if( mirror3_hi_addr )
			cpu_writemem24( mirror3_hi_addr, (data>>8)&0xff );
		else
			mirror3_word = (mirror3_word&0x00ff) | (data&0xff00);
	}

	if( (data&0x00ff0000)==0 ){
		if( mirror3_lo_addr )
			cpu_writemem24( mirror3_lo_addr, data&0xff );
		else
			mirror3_word = (mirror3_word&0xff00) | (data&0xff);
	}
}

static int mirror3_r( int offset ){
	int data = mirror3_word;
	if( mirror3_hi_addr ) data |= cpu_readmem24( mirror3_hi_addr )<<8;
	if( mirror3_lo_addr ) data |= cpu_readmem24( mirror3_lo_addr );

	if( data!= (input_port_0_r(offset) << 8) + input_port_1_r(offset) ){
		/*if( errorlog ) fprintf( errorlog, "bad\n" );*/
	}

	return data;
}

static void define_mirror3( int hi_addr, int lo_addr ){
	mirror3_word = 0;
	mirror3_hi_addr = hi_addr;
	mirror3_lo_addr = lo_addr;
}

/***************************************************************************/
#ifndef SYSTEM16_VIDEO_HZ_REDUCTION
#define SYSTEM16_VIDEO_HZ 60
#else
#define SYSTEM16_VIDEO_HZ 50
#endif

#define MACHINE_DRIVER( GAMENAME,READMEM,WRITEMEM,INITMACHINE,GFXSIZE ) \
static struct MachineDriver GAMENAME = \
{ \
	{ \
		{ \
			CPU_M68000, \
			10000000, \
			0, \
			READMEM,WRITEMEM,0,0, \
			sys16_interrupt,1 \
		}, \
		{ \
			CPU_Z80 | CPU_AUDIO_CPU, \
			4096000, \
			3, \
			sound_readmem,sound_writemem,sound_readport,sound_writeport, \
			ignore_interrupt,1 \
		}, \
	}, \
	SYSTEM16_VIDEO_HZ, DEFAULT_60HZ_VBLANK_DURATION, \
	1, \
	INITMACHINE, \
	40*8, 28*8, { 0*8, 40*8-1, 0*8, 28*8-1 }, \
	GFXSIZE, \
	2048,2048, \
	0, \
	VIDEO_TYPE_RASTER | VIDEO_MODIFIES_PALETTE | VIDEO_SUPPORTS_DIRTY, \
	0, \
	sys16_vh_start, \
	sys16_vh_stop, \
	sys16_vh_screenrefresh, \
	/*SOUND_SUPPORTS_STEREO*/0,0,0,0, \
	{ \
		{ \
			SOUND_YM2151, \
			&ym2151_interface \
		} \
	} \
};

/***************************************************************************/

int sys16_interrupt( void ){
	return 4; /* Interrupt vector 4, used by VBlank */
}

/***************************************************************************/

static struct MemoryReadAddress sound_readmem[] =
{
	{ 0x0000, 0x7fff, MRA_ROM },
	{ 0xf800, 0xffff, MRA_RAM },
	{ -1 }  /* end of table */
};

static struct MemoryWriteAddress sound_writemem[] =
{
	{ 0x0000, 0x7fff, MWA_ROM },
	{ 0xf800, 0xffff, MWA_RAM },
	{ -1 }  /* end of table */
};

static struct IOReadPort sound_readport[] =
{
	{ 0x01, 0x01, YM2151_status_port_0_r },
	{ 0xc0, 0xc0, soundlatch_r },
	{ -1 }	/* end of table */
};

static struct IOWritePort sound_writeport[] =
{
	{ 0x00, 0x00, YM2151_register_port_0_w },
	{ 0x01, 0x01, YM2151_data_port_0_w },
	{ 0x40, 0x40, IOWP_NOP },   /* adpcm? */
	{ 0x80, 0x80, IOWP_NOP },   /* ??? */
	{ -1 }
};

static void sound_command_w(int offset, int data){
	/*if( errorlog ) fprintf( errorlog, "SOUND COMMAND %04x <- %02x\n", offset, data&0xff );*/
	soundlatch_w( 0,data&0xff );
	cpu_cause_interrupt( 1, 0 );
}

static void irq_handler_mus(void){
}

static struct YM2151interface ym2151_interface =
{
	1,			/* 1 chip */
	4096000,	/* 3.58 MHZ ? */
	{ SYSTEM16_VIDEO_HZ },
	{ 0 }
};

/***************************************************************************/

static struct GfxLayout charlayout1 =
{
	8,8,	/* 8*8 chars */
	16384,	/* 16384 chars */
	3,	/* 3 bits per pixel */
	{ 0x20000*8, 0x10000*8, 0 },
		{ 0, 1, 2, 3, 4, 5, 6, 7 },
	{ 0*8, 1*8, 2*8, 3*8, 4*8, 5*8, 6*8, 7*8 },
	8*8	/* every sprite takes 8 consecutive bytes */
};

static struct GfxLayout charlayout2 =
{
	8,8,	/* 8*8 chars */
	16384,	/* 16384 chars */
	3,	/* 3 bits per pixel */
	{ 0x40000*8, 0x20000*8, 0 },
		{ 0, 1, 2, 3, 4, 5, 6, 7 },
	{ 0*8, 1*8, 2*8, 3*8, 4*8, 5*8, 6*8, 7*8 },
	8*8	/* every sprite takes 8 consecutive bytes */
};

static struct GfxLayout charlayout4 =
{
	8,8,	/* 8*8 chars */
	16384,	/* 16384 chars */
	3,	/* 3 bits per pixel */
	{ 0x80000*8, 0x40000*8, 0 },
		{ 0, 1, 2, 3, 4, 5, 6, 7 },
	{ 0*8, 1*8, 2*8, 3*8, 4*8, 5*8, 6*8, 7*8 },
	8*8	/* every sprite takes 8 consecutive bytes */
};

static struct GfxLayout charlayout8 =
{
	8,8,	/* 8*8 chars */
	16384,	/* 16384 chars */
	3,	/* 3 bits per pixel */
	{ 0x10000*8, 0x08000*8, 0 },
		{ 0, 1, 2, 3, 4, 5, 6, 7 },
	{ 0*8, 1*8, 2*8, 3*8, 4*8, 5*8, 6*8, 7*8 },
	8*8	/* every sprite takes 8 consecutive bytes */
};

static struct GfxDecodeInfo gfx1[] =
{
	{ 1, 0x00000, &charlayout1,	0, 256 },
	{ -1 } /* end of array */
};

static struct GfxDecodeInfo gfx2[] =
{
	{ 1, 0x00000, &charlayout2,	0, 256 },
	{ -1 } /* end of array */
};

static struct GfxDecodeInfo gfx4[] =
{
	{ 1, 0x00000, &charlayout4,	0, 256 },
	{ -1 } /* end of array */
};

static struct GfxDecodeInfo gfx8[] =
{
	{ 1, 0x00000, &charlayout8,	0, 256 },
	{ -1 } /* end of array */
};

/***************************************************************************/

void sys16_paletteram_w(int offset, int data){
	int oldword = READ_WORD (&paletteram[offset]);
	int newword = COMBINE_WORD (oldword, data);
	if( oldword!=newword ){
		/* we can do this, because we initialize palette RAM to all black in vh_start */

		/*	   byte 0    byte 1 */
		/*	GBGR BBBB GGGG RRRR */
		/*	5444 3210 3210 3210 */

		int r = (newword >> 0) & 0x0f;
		int g = (newword >> 4) & 0x0f;
		int b = (newword >> 8) & 0x0f;

		r = (r << 1);
		g = (g << 1);
		b = (b << 1);

		r = (r << 3) | (r >> 2);
		g = (g << 3) | (g >> 2);
		b = (b << 3) | (b >> 2);

		palette_change_color( offset/2, r,g,b );

		WRITE_WORD (&paletteram[offset], newword);
	}
}

/***************************************************************************/

static void set_refresh( int data ){
	sys16_refreshenable = data&0x20;
}

static void set_tile_bank( int data ){
	sys16_tile_bank1 = data&0xf;
	sys16_tile_bank0 = (data>>4)&0xf;
}

static void set_fg_page( int data ){
	sys16_fg_page[0] = data>>12;
	sys16_fg_page[1] = (data>>8)&0xf;
	sys16_fg_page[2] = (data>>4)&0xf;
	sys16_fg_page[3] = data&0xf;
}

static void set_bg_page( int data ){
	sys16_bg_page[0] = data>>12;
	sys16_bg_page[1] = (data>>8)&0xf;
	sys16_bg_page[2] = (data>>4)&0xf;
	sys16_bg_page[3] = data&0xf;
}

/***************************************************************************/
/*	Important: you must leave extra space when listing sprite ROMs
	in a ROM module definition.  This routine unpacks each sprite nibble
	into a byte, doubling the memory consumption. */

void sys16_sprite_decode( int num_banks, int bank_size ){
	unsigned char *base = Machine->memory_region[2];
	unsigned char *temp = (unsigned char *)gm_zi_malloc( bank_size );
	int i;

	if( !temp ) return;

	for( i = num_banks; i >0; i-- ){
		unsigned char *finish	= base + 2*bank_size*i;
		unsigned char *dest = finish - 2*bank_size;

		unsigned char *p1 = temp;
		unsigned char *p2 = temp+bank_size/2;

		unsigned char data;

		asm_memcpy (temp, base+bank_size*(i-1), bank_size);

		do {
			data = *p2++;
			*dest++ = data >> 4;
			*dest++ = data & 0xF;

			data = *p1++;
			*dest++ = data >> 4;
			*dest++ = data & 0xF;
		} while( dest<finish );
	}

	gm_free( temp );
}

/***************************************************************************/

static int io_player1_r( int offset ){ return input_port_0_r( offset ); }
static int io_player2_r( int offset ){ return input_port_1_r( offset ); }
static int io_player3_r( int offset ){ return input_port_5_r( offset ); }
static int io_service_r( int offset ){ return input_port_2_r( offset ); }

static int io_dip1_r( int offset ){ return input_port_3_r( offset ); }
static int io_dip2_r( int offset ){ return input_port_4_r( offset ); }

/***************************************************************************/

static void copy_rom64k( int dest, int source ){
	unsigned char *RAM = Machine->memory_region[Machine->drv->cpu[0].memory_region];
	asm_memcpy( &RAM[dest*0x10000], &RAM[source*0x10000], 0x10000 );
}

static void patch_code( int offset, int data ){
	int aligned_offset = offset&0xfffffe;
	unsigned char *RAM = Machine->memory_region[Machine->drv->cpu[0].memory_region];
	int old_word = READ_WORD( &RAM[aligned_offset] );

	if( offset&1 ){
		data = (old_word&0xff00)|data;
	}
	else {
		data = (old_word&0x00ff)|(data<<8);
	}

	WRITE_WORD (&RAM[aligned_offset], data);
}

/***************************************************************************/

#define SYS16_JOY1 PORT_START \
	PORT_BIT( 0x01, IP_ACTIVE_LOW, IPT_BUTTON3 ) \
	PORT_BIT( 0x02, IP_ACTIVE_LOW, IPT_BUTTON1 ) \
	PORT_BIT( 0x04, IP_ACTIVE_LOW, IPT_BUTTON2 ) \
	PORT_BIT( 0x08, IP_ACTIVE_LOW, IPT_UNKNOWN ) \
	PORT_BIT( 0x10, IP_ACTIVE_LOW, IPT_JOYSTICK_DOWN  | IPF_8WAY ) \
	PORT_BIT( 0x20, IP_ACTIVE_LOW, IPT_JOYSTICK_UP    | IPF_8WAY ) \
	PORT_BIT( 0x40, IP_ACTIVE_LOW, IPT_JOYSTICK_RIGHT | IPF_8WAY ) \
	PORT_BIT( 0x80, IP_ACTIVE_LOW, IPT_JOYSTICK_LEFT  | IPF_8WAY )

#define SYS16_JOY2 PORT_START \
	PORT_BIT( 0x01, IP_ACTIVE_LOW, IPT_BUTTON3 | IPF_COCKTAIL ) \
	PORT_BIT( 0x02, IP_ACTIVE_LOW, IPT_BUTTON1 | IPF_COCKTAIL ) \
	PORT_BIT( 0x04, IP_ACTIVE_LOW, IPT_BUTTON2 | IPF_COCKTAIL ) \
	PORT_BIT( 0x08, IP_ACTIVE_LOW, IPT_UNKNOWN ) \
	PORT_BIT( 0x10, IP_ACTIVE_LOW, IPT_JOYSTICK_DOWN  | IPF_8WAY | IPF_COCKTAIL ) \
	PORT_BIT( 0x20, IP_ACTIVE_LOW, IPT_JOYSTICK_UP    | IPF_8WAY | IPF_COCKTAIL ) \
	PORT_BIT( 0x40, IP_ACTIVE_LOW, IPT_JOYSTICK_RIGHT | IPF_8WAY | IPF_COCKTAIL ) \
	PORT_BIT( 0x80, IP_ACTIVE_LOW, IPT_JOYSTICK_LEFT  | IPF_8WAY | IPF_COCKTAIL )

#define SYS16_JOY3 PORT_START \
	PORT_BIT( 0x01, IP_ACTIVE_LOW, IPT_BUTTON3 | IPF_COCKTAIL ) \
	PORT_BIT( 0x02, IP_ACTIVE_LOW, IPT_BUTTON1 | IPF_COCKTAIL ) \
	PORT_BIT( 0x04, IP_ACTIVE_LOW, IPT_BUTTON2 | IPF_COCKTAIL ) \
	PORT_BIT( 0x08, IP_ACTIVE_LOW, IPT_UNKNOWN ) \
	PORT_BIT( 0x10, IP_ACTIVE_LOW, IPT_JOYSTICK_DOWN  | IPF_8WAY | IPF_PLAYER3 ) \
	PORT_BIT( 0x20, IP_ACTIVE_LOW, IPT_JOYSTICK_UP    | IPF_8WAY | IPF_PLAYER3 ) \
	PORT_BIT( 0x40, IP_ACTIVE_LOW, IPT_JOYSTICK_RIGHT | IPF_8WAY | IPF_PLAYER3 ) \
	PORT_BIT( 0x80, IP_ACTIVE_LOW, IPT_JOYSTICK_LEFT  | IPF_8WAY | IPF_PLAYER3 )

#define SYS16_SERVICE PORT_START \
	PORT_BIT( 0x01, IP_ACTIVE_LOW, IPT_COIN1 ) \
	PORT_BIT( 0x02, IP_ACTIVE_LOW, IPT_COIN2 ) \
	PORT_BITX(0x04, 0x04, 0, "Test Mode", OSD_KEY_F1, IP_JOY_NONE, 0 ) \
	PORT_BIT( 0x08, IP_ACTIVE_LOW, IPT_COIN3 ) \
	PORT_BIT( 0x10, IP_ACTIVE_LOW, IPT_START1 ) \
	PORT_BIT( 0x20, IP_ACTIVE_LOW, IPT_START2 ) \
	PORT_BIT( 0x40, IP_ACTIVE_LOW, IPT_UNKNOWN ) \
	PORT_BIT( 0x80, IP_ACTIVE_LOW, IPT_UNKNOWN )

#define SYS16_COINAGE PORT_START \
	PORT_DIPNAME( 0x0f, 0x0f, "Coin A", IP_KEY_NONE ) \
	PORT_DIPSETTING(    0x07, "4 Coins/1 Credit") \
	PORT_DIPSETTING(    0x08, "3 Coins/1 Credit") \
	PORT_DIPSETTING(    0x09, "2 Coins/1 Credit") \
	PORT_DIPSETTING(    0x05, "2/1 5/3 6/4") \
	PORT_DIPSETTING(    0x04, "2/1 4/3") \
	PORT_DIPSETTING(    0x0f, "1 Coin/1 Credit") \
	PORT_DIPSETTING(    0x01, "1/1 2/3") \
	PORT_DIPSETTING(    0x02, "1/1 4/5") \
	PORT_DIPSETTING(    0x03, "1/1 5/6") \
	PORT_DIPSETTING(    0x06, "2 Coins/3 Credits") \
	PORT_DIPSETTING(    0x0e, "1 Coin/2 Credits") \
	PORT_DIPSETTING(    0x0d, "1 Coin/3 Credits") \
	PORT_DIPSETTING(    0x0c, "1 Coin/4 Credits") \
	PORT_DIPSETTING(    0x0b, "1 Coin/5 Credits") \
	PORT_DIPSETTING(    0x0a, "1 Coin/6 Credits") \
	PORT_DIPSETTING(    0x00, "Free Play (if Coin B too) or 1/1") \
	PORT_DIPNAME( 0xf0, 0xf0, "Coin B", IP_KEY_NONE ) \
	PORT_DIPSETTING(    0x70, "4 Coins/1 Credit") \
	PORT_DIPSETTING(    0x80, "3 Coins/1 Credit") \
	PORT_DIPSETTING(    0x90, "2 Coins/1 Credit") \
	PORT_DIPSETTING(    0x50, "2/1 5/3 6/4") \
	PORT_DIPSETTING(    0x40, "2/1 4/3") \
	PORT_DIPSETTING(    0xf0, "1 Coin/1 Credit") \
	PORT_DIPSETTING(    0x10, "1/1 2/3") \
	PORT_DIPSETTING(    0x20, "1/1 4/5") \
	PORT_DIPSETTING(    0x30, "1/1 5/6") \
	PORT_DIPSETTING(    0x60, "2 Coins/3 Credits") \
	PORT_DIPSETTING(    0xe0, "1 Coin/2 Credits") \
	PORT_DIPSETTING(    0xd0, "1 Coin/3 Credits") \
	PORT_DIPSETTING(    0xc0, "1 Coin/4 Credits") \
	PORT_DIPSETTING(    0xb0, "1 Coin/5 Credits") \
	PORT_DIPSETTING(    0xa0, "1 Coin/6 Credits") \
	PORT_DIPSETTING(    0x00, "Free Play (if Coin A too) or 1/1")

#define SYS16_OPTIONS PORT_START \
	PORT_DIPNAME( 0x01, 0x00, "Cabinet", IP_KEY_NONE ) \
	PORT_DIPSETTING(    0x00, "Upright") \
	PORT_DIPSETTING(    0x01, "Cocktail") \
	PORT_DIPNAME( 0x02, 0x02, "Attract Mode Sound", IP_KEY_NONE ) \
	PORT_DIPSETTING(    0x02, "Off" ) \
	PORT_DIPSETTING(    0x00, "On" ) \
	PORT_DIPNAME( 0x0c, 0x0c, "Lives", IP_KEY_NONE ) \
	PORT_DIPSETTING(    0x08, "2" ) \
	PORT_DIPSETTING(    0x0c, "3" ) \
	PORT_DIPSETTING(    0x04, "5" ) \
	PORT_BITX( 0,       0x00, IPT_DIPSWITCH_SETTING | IPF_CHEAT, "240", IP_KEY_NONE, IP_JOY_NONE, 0 ) \
	PORT_DIPNAME( 0x30, 0x30, "Difficulty", IP_KEY_NONE ) \
	PORT_DIPSETTING(    0x20, "Easy" ) \
	PORT_DIPSETTING(    0x30, "Normal" ) \
	PORT_DIPSETTING(    0x10, "Hard" ) \
	PORT_DIPSETTING(    0x00, "Hardest" ) \
	PORT_DIPNAME( 0x40, 0x40, "Enemy's Bullet Speed", IP_KEY_NONE ) \
	PORT_DIPSETTING(    0x40, "Slow" ) \
	PORT_DIPSETTING(    0x00, "Fast" ) \
	PORT_DIPNAME( 0x80, 0x80, "Language", IP_KEY_NONE ) \
	PORT_DIPSETTING(    0x80, "Japanese" ) \
	PORT_DIPSETTING(    0x00, "English" )

/***************************************************************************/

ROM_START( aliensyn_rom )
	ROM_REGION( 0x030000 ) /* 68000 code */
	ROM_LOAD_ODD ( "11080.a1", 0x00000, 0x8000, 0xfe7378d9 )
	ROM_LOAD_EVEN( "11083.a4", 0x00000, 0x8000, 0xcb2ad9b3 )
	ROM_LOAD_ODD ( "11081.a2", 0x10000, 0x8000, 0x1308ee63 )
	ROM_LOAD_EVEN( "11084.a5", 0x10000, 0x8000, 0x2e1ec7b1 )
	ROM_LOAD_ODD ( "11082.a3", 0x20000, 0x8000, 0x9cdc2a14 )
	ROM_LOAD_EVEN( "11085.a6", 0x20000, 0x8000, 0xcff78f39 )

	ROM_REGION( 0x30000 ) /* tiles */
	ROM_LOAD( "10702.b9",  0x00000, 0x10000, 0x393bc813 )
	ROM_LOAD( "10703.b10", 0x10000, 0x10000, 0x6b6dd9f5 )
	ROM_LOAD( "10704.b11", 0x20000, 0x10000, 0x911e7ebc )

	ROM_REGION( 0x080000*2 ) /* sprites */
	ROM_LOAD( "10709.b1", 0x00000, 0x10000, 0xaddf0a90 )
	ROM_LOAD( "10713.b5", 0x10000, 0x10000, 0xececde3a )
	ROM_LOAD( "10710.b2", 0x20000, 0x10000, 0x992369eb )
	ROM_LOAD( "10714.b6", 0x30000, 0x10000, 0x91bf42fb )
	ROM_LOAD( "10711.b3", 0x40000, 0x10000, 0x29166ef6 )
	ROM_LOAD( "10715.b7", 0x50000, 0x10000, 0xa7c57384 )
	ROM_LOAD( "10712.b4", 0x60000, 0x10000, 0x876ad019 )
	ROM_LOAD( "10716.b8", 0x70000, 0x10000, 0x40ba1d48 )

	ROM_REGION( 0x10000 ) /* sound CPU */
	ROM_LOAD( "10723.a7", 0x0000, 0x8000, 0x99953526 )
ROM_END

/***************************************************************************/

static struct MemoryReadAddress aliensyn_readmem[] =
{
	{ 0xc41002, 0xc41003, io_player1_r },
	{ 0xc41006, 0xc41007, io_player2_r },
	{ 0xc41000, 0xc41001, io_service_r },
	{ 0xc42002, 0xc42003, io_dip1_r },
	{ 0xc42000, 0xc42001, io_dip2_r },

	{ 0x410000, 0x410fff, MRA_TEXTRAM },
	{ 0x400000, 0x40ffff, MRA_TILERAM },
	{ 0x440000, 0x440fff, MRA_SPRITERAM },
	{ 0x840000, 0x840fff, MRA_PALETTERAM },
	{ 0xc40000, 0xc40fff, MRA_EXTRAM },
	{ 0xff0000, 0xffffff, MRA_WORKINGRAM },
	{ 0x000000, 0x02ffff, MRA_ROM },
	{-1}
};

static struct MemoryWriteAddress aliensyn_writemem[] =
{
	{ 0x000000, 0x03ffff, MWA_ROM },
	{ 0x400000, 0x40ffff, MWA_TILERAM },
	{ 0x410000, 0x410fff, MWA_TEXTRAM },
	{ 0x440000, 0x440fff, MWA_SPRITERAM },
	{ 0x840000, 0x840fff, MWA_PALETTERAM },
	{ 0xc00006, 0xc00007, sound_command_w },
	{ 0xc40000, 0xc40fff, MWA_EXTRAM },
	{ 0xff0000, 0xffffff, MWA_WORKINGRAM },
	{-1}
};

/***************************************************************************/

void aliensyn_update_proc( void ){
	sys16_fg_scrollx = READ_WORD( &sys16_textram[0x0e98] );
	sys16_bg_scrollx = READ_WORD( &sys16_textram[0x0e9a] );
	sys16_fg_scrolly = READ_WORD( &sys16_textram[0x0e90] );
	sys16_bg_scrolly = READ_WORD( &sys16_textram[0x0e92] );

	set_fg_page( READ_WORD( &sys16_textram[0x0e80] ) );
	set_bg_page( READ_WORD( &sys16_textram[0x0e82] ) );

	set_refresh( READ_WORD( &sys16_extraram[0] ) );
}

void aliensyn_init_machine( void ){
	static int bank[16] = { 0,0,0,0,0,0,0,6,0,0,0,4,0,2,0,0 };
	sys16_obj_bank = bank;

	sys16_update_proc = aliensyn_update_proc;
}

void aliensyn_sprite_decode( void ){
	sys16_sprite_decode( 4,0x20000 );
}

/***************************************************************************/

INPUT_PORTS_START( aliensyn_input_ports )
	SYS16_JOY1
	SYS16_JOY2
	SYS16_SERVICE
	SYS16_COINAGE

	PORT_START	/* DSW1 */
		PORT_DIPNAME( 0x01, 0x00, "Unknown", IP_KEY_NONE )
		PORT_DIPSETTING(    0x00, "On")
		PORT_DIPSETTING(    0x01, "Off")
		PORT_DIPNAME( 0x02, 0x02, "Demo Sound?", IP_KEY_NONE )
		PORT_DIPSETTING(    0x02, "Off" )
		PORT_DIPSETTING(    0x00, "On" )
		PORT_DIPNAME( 0x0c, 0x0c, "Lives", IP_KEY_NONE )
		PORT_DIPSETTING(    0x08, "2" )
		PORT_DIPSETTING(    0x0c, "3" )
		PORT_DIPSETTING(    0x04, "4" )
		PORT_BITX( 0,       0x00, IPT_DIPSWITCH_SETTING | IPF_CHEAT, "Free (127?)", IP_KEY_NONE, IP_JOY_NONE, 0 )
		PORT_DIPNAME( 0x30, 0x30, "Timer", IP_KEY_NONE )
		PORT_DIPSETTING(    0x30, "150" )
		PORT_DIPSETTING(    0x20, "140" )
		PORT_DIPSETTING(    0x10, "130" )
		PORT_DIPSETTING(    0x00, "120" )
		PORT_DIPNAME( 0xc0, 0xc0, "Difficulty", IP_KEY_NONE )
		PORT_DIPSETTING(    0x80, "Easy" )
		PORT_DIPSETTING(    0xc0, "Normal" )
		PORT_DIPSETTING(    0x40, "Hard" )
	PORT_DIPSETTING(    0x00, "Hardest" )
INPUT_PORTS_END

/***************************************************************************/

MACHINE_DRIVER( aliensyn_machine_driver, \
	aliensyn_readmem,aliensyn_writemem,aliensyn_init_machine, gfx1 )

struct GameDriver aliensyn_driver =
{
	__FILE__,
	0,
	"aliensyn",
	"Alien Syndrome",
	"1987",
	"Sega",
	SYS16_CREDITS,
	0,
	&aliensyn_machine_driver,
	0,
	aliensyn_rom,
	aliensyn_sprite_decode, 0,
	0,
	0,
	aliensyn_input_ports,
	0, 0, 0,
	ORIENTATION_DEFAULT,
	0, 0
};

/***************************************************************************/

ROM_START( altbeast_rom )
	ROM_REGION( 0x040000 ) /* 68000 code */
	ROM_LOAD_ODD ( "ab11739.bin", 0x000000, 0x20000, 0xe466eb65 )
	ROM_LOAD_EVEN( "ab11740.bin", 0x000000, 0x20000, 0xce227542 )

	ROM_REGION( 0x60000 ) /* tiles */
	ROM_LOAD( "ab11674.bin", 0x00000, 0x20000, 0xa57a66d5 )
	ROM_LOAD( "ab11675.bin", 0x20000, 0x20000, 0x2ef2f144 )
	ROM_LOAD( "ab11676.bin", 0x40000, 0x20000, 0x0c04acac )

	ROM_REGION( 0xe0000*2 ) /* sprites */
	ROM_LOAD( "ab11677.bin", 0x00000, 0x10000, 0xf8b3684e )
	ROM_LOAD( "ab11681.bin", 0x10000, 0x10000, 0xae3c2793 )
	ROM_LOAD( "ab11726.bin", 0x20000, 0x10000, 0x3cce5419 )
	ROM_LOAD( "ab11730.bin", 0x30000, 0x10000, 0x3af62b55 )
	ROM_LOAD( "ab11678.bin", 0x40000, 0x10000, 0xb0390078 )
	ROM_LOAD( "ab11682.bin", 0x50000, 0x10000, 0x2a87744a )
	ROM_LOAD( "ab11728.bin", 0x60000, 0x10000, 0xf3a43fd8 )
	ROM_LOAD( "ab11732.bin", 0x70000, 0x10000, 0x2fb3e355 )
	ROM_LOAD( "ab11679.bin", 0x80000, 0x10000, 0x676be0cb )
	ROM_LOAD( "ab11683.bin", 0x90000, 0x10000, 0x802cac94 )
	ROM_LOAD( "ab11718.bin", 0xa0000, 0x10000, 0x882864c2 )
	ROM_LOAD( "ab11734.bin", 0xb0000, 0x10000, 0x76c704d2 )
	ROM_LOAD( "ab11680.bin", 0xc0000, 0x10000, 0x339987f7 )
	ROM_LOAD( "ab11684.bin", 0xd0000, 0x10000, 0x4fe406aa )

	ROM_REGION( 0x10000 ) /* sound CPU */
	ROM_LOAD( "ab11671.bin", 0x0000, 0x8000, 0x2b71343b )
ROM_END

/***************************************************************************/

static int altbeast_skip(int offset)
{
	if (cpu_getpc()==0x3994) {cpu_spinuntil_int(); return 1<<8;}

	return READ_WORD(&sys16_workingram[0xf01c]);
}

static struct MemoryReadAddress altbeast_readmem[] =
{
	{ 0xc41002, 0xc41003, io_player1_r },
	{ 0xc41006, 0xc41007, io_player2_r },
	{ 0xc41000, 0xc41001, io_service_r },
	{ 0xc42002, 0xc42003, io_dip1_r },
	{ 0xc42000, 0xc42001, io_dip2_r },

	{ 0x410000, 0x410fff, MRA_TEXTRAM },
	{ 0x400000, 0x40ffff, MRA_TILERAM },
	{ 0x440000, 0x440fff, MRA_SPRITERAM },
	{ 0x840000, 0x840fff, MRA_PALETTERAM },
	{ 0xc40000, 0xc40fff, MRA_EXTRAM },

  { 0xfff01c, 0xfff01d, altbeast_skip },

	{ 0xff0000, 0xffffff, MRA_WORKINGRAM },
	{ 0x000000, 0x03ffff, MRA_ROM },
	{-1}
};

static struct MemoryWriteAddress altbeast_writemem[] =
{
	{ 0x000000, 0x03ffff, MWA_ROM },
	{ 0xfe0006, 0xfe0007, sound_command_w },
	{ 0x410000, 0x410fff, MWA_TEXTRAM },
	{ 0x400000, 0x40ffff, MWA_TILERAM },
	{ 0x440000, 0x44ffff, MWA_SPRITERAM },
	{ 0x840000, 0x84ffff, MWA_PALETTERAM },
	{ 0xc40000, 0xc40fff, MWA_EXTRAM },
	{ 0xff0000, 0xffffff, MWA_WORKINGRAM },
	{-1}
};

/***************************************************************************/

void altbeast_update_proc( void ){
	sys16_fg_scrollx = READ_WORD( &sys16_textram[0x0e98] );
	sys16_bg_scrollx = READ_WORD( &sys16_textram[0x0e9a] );
	sys16_fg_scrolly = READ_WORD( &sys16_textram[0x0e90] );
	sys16_bg_scrolly = READ_WORD( &sys16_textram[0x0e92] );

	set_fg_page( READ_WORD( &sys16_textram[0x0e80] ) );
	set_bg_page( READ_WORD( &sys16_textram[0x0e82] ) );

	set_tile_bank( READ_WORD( &sys16_workingram[0xf094] ) );
	set_refresh( READ_WORD( &sys16_extraram[0] ) );
}

void altbeast_init_machine( void ){
	static int bank[16] = {0x00,0x00,0x02,0x00,0x04,0x00,0x06,0x00,0x08,0x00,0x0A,0x00,0x0C,0x00,0x00,0x00};
	sys16_obj_bank = bank;
	sys16_update_proc = altbeast_update_proc;
}

void altbeast_sprite_decode( void ){
	sys16_sprite_decode( 7,0x20000 );
}
/***************************************************************************/

INPUT_PORTS_START( altbeast_input_ports )
	SYS16_JOY1
	SYS16_JOY2
	SYS16_SERVICE
	SYS16_COINAGE

	PORT_START	/* DSW1 */
		PORT_DIPNAME( 0x01, 0x01, "Credits needed", IP_KEY_NONE )
		PORT_DIPSETTING(    0x01, "1 to start, 1 to continue")
		PORT_DIPSETTING(    0x00, "2 to start, 1 to continue")
		PORT_DIPNAME( 0x02, 0x02, "Demo Sounds", IP_KEY_NONE )
		PORT_DIPSETTING(    0x02, "Off" )
		PORT_DIPSETTING(    0x00, "On" )
		PORT_DIPNAME( 0x0c, 0x0c, "Lives", IP_KEY_NONE )
		PORT_DIPSETTING(    0x08, "2" )
		PORT_DIPSETTING(    0x0c, "3" )
		PORT_DIPSETTING(    0x04, "4" )
		PORT_BITX( 0,       0x00, IPT_DIPSWITCH_SETTING | IPF_CHEAT, "240", IP_KEY_NONE, IP_JOY_NONE, 0 )
		PORT_DIPNAME( 0x30, 0x30, "Energy Meter", IP_KEY_NONE )
		PORT_DIPSETTING(    0x20, "2" )
		PORT_DIPSETTING(    0x30, "3" )
		PORT_DIPSETTING(    0x10, "4" )
		PORT_DIPSETTING(    0x00, "5" )
		PORT_DIPNAME( 0xc0, 0xc0, "Difficulty", IP_KEY_NONE )
		PORT_DIPSETTING(    0x80, "Easy" )
		PORT_DIPSETTING(    0xc0, "Normal" )
		PORT_DIPSETTING(    0x40, "Hard" )
	PORT_DIPSETTING(    0x00, "Hardest" )
INPUT_PORTS_END

/***************************************************************************/

MACHINE_DRIVER( altbeast_machine_driver, \
	altbeast_readmem,altbeast_writemem,altbeast_init_machine, gfx2 )

struct GameDriver altbeast_driver =
{
	__FILE__,
	0,
	"altbeast",
	"Altered Beast",
	"1988",
	"Sega",
	SYS16_CREDITS,
	0,
	&altbeast_machine_driver,
	0,
	altbeast_rom,
	altbeast_sprite_decode, 0,
	0,
	0,
	altbeast_input_ports,
	0, 0, 0,
	ORIENTATION_DEFAULT,
	0, 0
};

/***************************************************************************/

ROM_START( goldnaxe_rom )
	ROM_REGION( 0x0c0000 ) /* 68000 code */
	ROM_LOAD_ODD ( "ga12522.bin", 0x00000, 0x20000, 0xb6c35160 )
	ROM_LOAD_EVEN( "ga12523.bin", 0x00000, 0x20000, 0x8e6128d7 )
	ROM_LOAD_ODD ( "ga12544.bin", 0x40000, 0x40000, 0x5e38f668 )
	ROM_LOAD_EVEN( "ga12545.bin", 0x40000, 0x40000, 0xa97c4e4d )

	ROM_REGION( 0x60000 ) /* tiles */
	ROM_LOAD( "ga12385.bin", 0x00000, 0x20000, 0xb8a4e7e0 )
	ROM_LOAD( "ga12386.bin", 0x20000, 0x20000, 0x25d7d779 )
	ROM_LOAD( "ga12387.bin", 0x40000, 0x20000, 0xc7fcadf3 )

	ROM_REGION( 0x180000*2 ) /* sprites */
	ROM_LOAD( "ga12378.bin", 0x000000, 0x40000, 0x119e5a82 )
	ROM_LOAD( "ga12379.bin", 0x040000, 0x40000, 0x1a0e8c57 )
	ROM_LOAD( "ga12380.bin", 0x080000, 0x40000, 0xbb2c0853 )
	ROM_LOAD( "ga12381.bin", 0x0c0000, 0x40000, 0x81ba6ecc )
	ROM_LOAD( "ga12382.bin", 0x100000, 0x40000, 0x81601c6f )
	ROM_LOAD( "ga12383.bin", 0x140000, 0x40000, 0x5dbacf7a )

	ROM_REGION( 0x10000 ) /* sound CPU */
	ROM_LOAD( "ga12390.bin", 0x0000, 0x8000, 0x399fc5f5 )
ROM_END

/***************************************************************************/

static struct MemoryReadAddress goldnaxe_readmem[] =
{
	{ 0xc41002, 0xc41003, io_player1_r },
	{ 0xc41006, 0xc41007, io_player2_r },
	{ 0xc41000, 0xc41001, io_service_r },
	{ 0xc42002, 0xc42003, io_dip1_r },
	{ 0xc42000, 0xc42001, io_dip2_r },

	{ 0x110000, 0x110fff, MRA_TEXTRAM },
	{ 0x100000, 0x10ffff, MRA_TILERAM },
	{ 0x200000, 0x200fff, MRA_SPRITERAM },
	{ 0x140000, 0x140fff, MRA_PALETTERAM },
	{ 0x1f0000, 0x1fffff, MRA_EXTRAM },
	{ 0xc40000, 0xc40fff, MRA_EXTRAM2 },
	{ 0xffecd0, 0xffecd1, mirror1_r },
	{ 0xffec96, 0xffec97, mirror2_r },
	{ 0xffecfc, 0xffecfd, mirror3_r },
	{ 0xff0000, 0xffffff, MRA_WORKINGRAM },
	{ 0x000000, 0x0bffff, MRA_ROM },
	{-1}
};

static struct MemoryWriteAddress goldnaxe_writemem[] =
{
	{ 0x000000, 0x0bffff, MWA_ROM },
	{ 0xfe0006, 0xfe0007, sound_command_w },
	{ 0x110000, 0x110fff, MWA_TEXTRAM },
	{ 0x100000, 0x10ffff, MWA_TILERAM },
	{ 0x200000, 0x20ffff, MWA_SPRITERAM },
	{ 0x140000, 0x14ffff, MWA_PALETTERAM },
	{ 0x1f0000, 0x1fffff, MWA_EXTRAM },
	{ 0xc40000, 0xc40fff, MWA_EXTRAM2 },
	{ 0xffecd0, 0xffecd1, mirror1_w },
	{ 0xffec96, 0xffec97, mirror2_w },
	{ 0xffecfc, 0xffecfd, mirror3_w },
	{ 0xff0000, 0xffffff, MWA_WORKINGRAM },
	{-1}
};
/***************************************************************************/

void goldnaxe_update_proc( void ){
	sys16_fg_scrollx = READ_WORD( &sys16_textram[0x0e98] );
	sys16_bg_scrollx = READ_WORD( &sys16_textram[0x0e9a] );
	sys16_fg_scrolly = READ_WORD( &sys16_textram[0x0e90] );
	sys16_bg_scrolly = READ_WORD( &sys16_textram[0x0e92] );

	set_fg_page( READ_WORD( &sys16_textram[0x0e80] ) );
	set_bg_page( READ_WORD( &sys16_textram[0x0e82] ) );
	set_tile_bank( READ_WORD( &sys16_workingram[0xec94] ) );
	set_refresh( READ_WORD( &sys16_extraram2[0] ) );
}

void goldnaxe_init_machine( void ){
	static int bank[16] = { 0,2,8,10,16,18,0,0,4,6,12,14,20,22,0,0 };
	sys16_obj_bank = bank;

	copy_rom64k( 0x6, 0xA );
	copy_rom64k( 0x7, 0xB );

	patch_code( 0x3CB2, 0x4E );
	patch_code( 0x3CB3, 0x75 );

	define_mirror1( 0xc41003, 0xc41007 );
	define_mirror2( 0xc41001, 0 );
	define_mirror3( 0xfe0007,0 );

	sys16_sprxoffset = -0xb8;
	sys16_update_proc = goldnaxe_update_proc;
}

void goldnaxe_sprite_decode( void ){
	sys16_sprite_decode( 3,0x80000 );
}
/***************************************************************************/

INPUT_PORTS_START( goldnaxe_input_ports )
	SYS16_JOY1
	SYS16_JOY2
	SYS16_SERVICE
	SYS16_COINAGE

	PORT_START	/* DSW1 */
		PORT_DIPNAME( 0x01, 0x01, "Credits needed", IP_KEY_NONE )
		PORT_DIPSETTING(    0x01, "1 to start, 1 to continue")
		PORT_DIPSETTING(    0x00, "2 to start, 1 to continue")
		PORT_DIPNAME( 0x02, 0x02, "Attract Mode Sound", IP_KEY_NONE )
		PORT_DIPSETTING(    0x02, "Off" )
		PORT_DIPSETTING(    0x00, "On" )
		PORT_DIPNAME( 0x0c, 0x0c, "Lives", IP_KEY_NONE )
		PORT_DIPSETTING(    0x08, "1" )
		PORT_DIPSETTING(    0x0c, "2" )
		PORT_DIPSETTING(    0x04, "3" )
		PORT_DIPSETTING(    0x00, "4" )
		PORT_DIPNAME( 0x30, 0x30, "Energy Meter", IP_KEY_NONE )
		PORT_DIPSETTING(    0x20, "2" )
		PORT_DIPSETTING(    0x30, "3" )
		PORT_DIPSETTING(    0x10, "4" )
		PORT_DIPSETTING(    0x00, "5" )
	PORT_BIT( 0xc0, IP_ACTIVE_LOW, IPT_UNUSED )
INPUT_PORTS_END

/***************************************************************************/

MACHINE_DRIVER( goldnaxe_machine_driver, \
	goldnaxe_readmem,goldnaxe_writemem,goldnaxe_init_machine, gfx2 )

struct GameDriver goldnaxe_driver =
{
	__FILE__,
	0,
	"goldnaxe",
	"Golden Axe",
	"1989",
	"Sega",
	SYS16_CREDITS,
	0,
	&goldnaxe_machine_driver,
	0,
	goldnaxe_rom,
	goldnaxe_sprite_decode, 0,
	0,
	0,
	goldnaxe_input_ports,
	0, 0, 0,
	ORIENTATION_DEFAULT,
	0, 0
};

/***************************************************************************/

ROM_START( passshtb_rom )
	ROM_REGION( 0x020000 ) /* 68000 code */
	ROM_LOAD_ODD ( "pass4_2p.bin", 0x000000, 0x10000, 0x06ac6d5d )
	ROM_LOAD_EVEN( "pass3_2p.bin", 0x000000, 0x10000, 0x26bb9299 )

	ROM_REGION( 0x30000 ) /* tiles */
	ROM_LOAD( "passshot.b9",  0x00000, 0x10000, 0xd31c0b6c )
	ROM_LOAD( "passshot.b10", 0x10000, 0x10000, 0xb78762b4 )
	ROM_LOAD( "passshot.b11", 0x20000, 0x10000, 0xea49f666 )

	ROM_REGION( 0x60000*2 ) /* sprites */
	ROM_LOAD( "passshot.b1", 0x00000, 0x010000, 0xb6e94727 )
	ROM_LOAD( "passshot.b5", 0x10000, 0x010000, 0x17e8d5d5 )
	ROM_LOAD( "passshot.b2", 0x20000, 0x010000, 0x3e670098 )
	ROM_LOAD( "passshot.b6", 0x30000, 0x010000, 0x50eb71cc )
	ROM_LOAD( "passshot.b3", 0x40000, 0x010000, 0x05733ca8 )
	ROM_LOAD( "passshot.b7", 0x50000, 0x010000, 0x81e49697 )

	ROM_REGION( 0x10000 ) /* sound CPU */
	ROM_LOAD( "passshot.a7", 0x0000, 0x8000, 0x789edc06 )
ROM_END

/***************************************************************************/

static struct MemoryReadAddress passshtb_readmem[] =
{
	{ 0xc41002, 0xc41003, io_player1_r },
	{ 0xc41006, 0xc41007, io_player2_r },
	{ 0xc41000, 0xc41001, io_service_r },
	{ 0xc42002, 0xc42003, io_dip1_r },
	{ 0xc42000, 0xc42001, io_dip2_r },

	{ 0x410000, 0x410fff, MRA_TEXTRAM },
	{ 0x400000, 0x40ffff, MRA_TILERAM },
	{ 0x440000, 0x440fff, MRA_SPRITERAM },
	{ 0x840000, 0x840fff, MRA_PALETTERAM },
	{ 0xc40000, 0xc40fff, MRA_EXTRAM },
	{ 0xff0000, 0xffffff, MRA_WORKINGRAM },
	{ 0x000000, 0x01ffff, MRA_ROM },
	{-1}
};

static struct MemoryWriteAddress passshtb_writemem[] =
{
	{ 0x000000, 0x01ffff, MWA_ROM },
	{ 0xc42006, 0xc42007, sound_command_w },
	{ 0x410000, 0x410fff, MWA_TEXTRAM },
	{ 0x400000, 0x40ffff, MWA_TILERAM },
	{ 0x440000, 0x44ffff, MWA_SPRITERAM },
	{ 0x840000, 0x84ffff, MWA_PALETTERAM },
	{ 0xc40000, 0xc40fff, MWA_EXTRAM },
	{ 0xff0000, 0xffffff, MWA_WORKINGRAM },
	{-1}
};
/***************************************************************************/

void passshtb_update_proc( void ){
	sys16_fg_scrollx = READ_WORD( &sys16_workingram[0xf4be] );
	sys16_bg_scrollx = READ_WORD( &sys16_workingram[0xf4c2] );
	sys16_fg_scrolly = READ_WORD( &sys16_workingram[0xf4bc] );
	sys16_bg_scrolly = READ_WORD( &sys16_workingram[0xf4c0] );

	set_fg_page( READ_WORD( &sys16_textram[0x0ff6] ) );
	set_bg_page( READ_WORD( &sys16_textram[0x0ff4] ) );
	set_refresh( READ_WORD( &sys16_extraram[0] ) );
}

void passshtb_init_machine( void ){
	static int bank[16] = { 0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,3 };
	sys16_obj_bank = bank;

	sys16_sprxoffset = -0x48;
	sys16_spritesystem = 0;
	sys16_update_proc = passshtb_update_proc;
}

void passshtb_sprite_decode( void ){
	sys16_sprite_decode( 3,0x20000 );
}
/***************************************************************************/

INPUT_PORTS_START( passshtb_input_ports )
	SYS16_JOY1
	SYS16_JOY2
	SYS16_SERVICE
	SYS16_COINAGE

	PORT_START	/* DSW1 */
		PORT_DIPNAME( 0x01, 0x01, "Attract Mode Sound", IP_KEY_NONE )
		PORT_DIPSETTING(    0x01, "Off" )
		PORT_DIPSETTING(    0x00, "On" )
		PORT_DIPNAME( 0x0e, 0x0e, "Initial Point", IP_KEY_NONE )
		PORT_DIPSETTING(    0x06, "2000" )
		PORT_DIPSETTING(    0x0a, "3000" )
		PORT_DIPSETTING(    0x0c, "4000" )
		PORT_DIPSETTING(    0x0e, "5000" )
		PORT_DIPSETTING(    0x08, "6000" )
		PORT_DIPSETTING(    0x04, "7000" )
		PORT_DIPSETTING(    0x02, "8000" )
		PORT_DIPSETTING(    0x00, "9000" )
		PORT_DIPNAME( 0x30, 0x30, "Point Table", IP_KEY_NONE )
		PORT_DIPSETTING(    0x20, "Easy" )
		PORT_DIPSETTING(    0x30, "Normal" )
		PORT_DIPSETTING(    0x10, "Hard" )
		PORT_DIPSETTING(    0x00, "Hardest" )
		PORT_DIPNAME( 0xc0, 0xc0, "Game Difficulty", IP_KEY_NONE )
		PORT_DIPSETTING(    0x80, "Easy" )
		PORT_DIPSETTING(    0xc0, "Normal" )
		PORT_DIPSETTING(    0x40, "Hard" )
	PORT_DIPSETTING(    0x00, "Hardest" )
INPUT_PORTS_END

/***************************************************************************/

MACHINE_DRIVER( passshtb_machine_driver, \
	passshtb_readmem,passshtb_writemem,passshtb_init_machine, gfx1 )

struct GameDriver passshtb_driver =
{
	__FILE__,
	0,
	"passshtb",
	"Passing Shot (bootleg)",
	"????",
	"bootleg",
	SYS16_CREDITS,
	0,
	&passshtb_machine_driver,
	0,
	passshtb_rom,
	passshtb_sprite_decode, 0,
	0,
	0,
	passshtb_input_ports,
	0, 0, 0,
	ORIENTATION_DEFAULT,
	0, 0
};

/***************************************************************************/

ROM_START( sdi_rom )
	ROM_REGION( 0x030000 ) /* 68000 code */
	ROM_LOAD_ODD ( "a1.rom", 0x000000, 0x8000, 0xa9f816ef )
	ROM_LOAD_EVEN( "a4.rom", 0x000000, 0x8000, 0xf2c41dd6 )
	ROM_LOAD_ODD ( "a2.rom", 0x010000, 0x8000, 0x369af326 )
	ROM_LOAD_EVEN( "a5.rom", 0x010000, 0x8000, 0x7952e27e )
	ROM_LOAD_ODD ( "a3.rom", 0x020000, 0x8000, 0x193e4231 )
	ROM_LOAD_EVEN( "a6.rom", 0x020000, 0x8000, 0x8ee2c287 )

	ROM_REGION( 0x30000 ) /* tiles */
	ROM_LOAD( "b9.rom",  0x00000, 0x10000, 0x182b6301 )
	ROM_LOAD( "b10.rom", 0x10000, 0x10000, 0x8f7129a2 )
	ROM_LOAD( "b11.rom", 0x20000, 0x10000, 0x4409411f )

	ROM_REGION( 0x060000*2 ) /* sprites */
	ROM_LOAD( "b1.rom", 0x000000, 0x010000, 0x30e2c50a )
	ROM_LOAD( "b5.rom", 0x010000, 0x010000, 0x794e3e8b )
	ROM_LOAD( "b2.rom", 0x020000, 0x010000, 0x6a8b3fd0 )
	ROM_LOAD( "b6.rom", 0x030000, 0x010000, 0x602da5d5 )
	ROM_LOAD( "b3.rom", 0x040000, 0x010000, 0xb9de3aeb )
	ROM_LOAD( "b7.rom", 0x050000, 0x010000, 0x0a73a057 )

	ROM_REGION( 0x10000 ) /* sound CPU */
	ROM_LOAD( "a7.rom", 0x0000, 0x8000, 0x793f9f7f )
ROM_END

/***************************************************************************/

static struct MemoryReadAddress sdi_readmem[] =
{
	{ 0xc41004, 0xc41005, io_player1_r },
	{ 0xc41002, 0xc41003, io_player2_r },
	{ 0xc41000, 0xc41001, io_service_r },
	{ 0xc42002, 0xc42003, io_dip1_r },
	{ 0xc42000, 0xc42001, io_dip2_r },

	{ 0x410000, 0x410fff, MRA_TEXTRAM },
	{ 0x400000, 0x40ffff, MRA_TILERAM },
	{ 0x440000, 0x440fff, MRA_SPRITERAM },
	{ 0x840000, 0x840fff, MRA_PALETTERAM },
	{ 0xff0000, 0xffffff, MRA_WORKINGRAM },
	{ 0x000000, 0x02ffff, MRA_ROM },
	{-1}
};

static struct MemoryWriteAddress sdi_writemem[] =
{
	{ 0x000000, 0x02ffff, MWA_ROM },
	{ 0xfe0006, 0xfe0007, sound_command_w },
	{ 0x410000, 0x410fff, MWA_TEXTRAM },
	{ 0x400000, 0x40ffff, MWA_TILERAM },
	{ 0x440000, 0x44ffff, MWA_SPRITERAM },
	{ 0x840000, 0x84ffff, MWA_PALETTERAM },
	{ 0xff0000, 0xffffff, MWA_WORKINGRAM },
	{-1}
};
/***************************************************************************/

void sdi_update_proc( void ){
	sys16_fg_scrollx = READ_WORD( &sys16_textram[0x0e98] );
	sys16_bg_scrollx = READ_WORD( &sys16_textram[0x0e9a] );
	sys16_fg_scrolly = READ_WORD( &sys16_textram[0x0e90] );
	sys16_bg_scrolly = READ_WORD( &sys16_textram[0x0e92] );

	set_fg_page( READ_WORD( &sys16_textram[0x0e80] ) );
	set_bg_page( READ_WORD( &sys16_textram[0x0e82] ) );
}

void sdi_init_machine( void ){
	static int bank[16] = {00,00,00,00,00,00,00,0x06,00,00,00,0x04,00,0x02,00,00};
	sys16_obj_bank = bank;

	patch_code( 0x110c, 0x80 );
	patch_code( 0x102f2, 0x00 );
	patch_code( 0x102f3, 0x02 );

	sys16_update_proc = sdi_update_proc;
}

void sdi_sprite_decode( void ){
	sys16_sprite_decode( 3,0x020000 );
}
/***************************************************************************/

INPUT_PORTS_START( sdi_input_ports )
	SYS16_JOY1
	SYS16_JOY2
	SYS16_SERVICE
	SYS16_COINAGE
	SYS16_OPTIONS
INPUT_PORTS_END

/***************************************************************************/

MACHINE_DRIVER( sdi_machine_driver, \
	sdi_readmem,sdi_writemem,sdi_init_machine, gfx1 )

struct GameDriver sdi_driver =
{
	__FILE__,
	0,
	"sdi",
	"SDI",
	"1987",
	"Sega",
	SYS16_CREDITS,
	GAME_NOT_WORKING,
	&sdi_machine_driver,
	0,
	sdi_rom,
	sdi_sprite_decode, 0,
	0,
	0,
	sdi_input_ports,
	0, 0, 0,
	ORIENTATION_DEFAULT,
	0, 0
};

/***************************************************************************/

ROM_START( shinobi_rom )
	ROM_REGION( 0x040000 ) /* 68000 code */
	ROM_LOAD_ODD ( "shinobi.a1", 0x000000, 0x10000, 0x343f4c46 )
	ROM_LOAD_EVEN( "shinobi.a4", 0x000000, 0x10000, 0xb930399d )
	ROM_LOAD_ODD ( "shinobi.a2", 0x020000, 0x10000, 0x7961d07e )
	ROM_LOAD_EVEN( "shinobi.a5", 0x020000, 0x10000, 0x9d46e707 )

	ROM_REGION( 0x30000 ) /* tiles */
	ROM_LOAD( "shinobi.b9",  0x00000, 0x10000, 0x5f62e163 )
	ROM_LOAD( "shinobi.b10", 0x10000, 0x10000, 0x75f8fbc9 )
	ROM_LOAD( "shinobi.b11", 0x20000, 0x10000, 0x06508bb9 )

	ROM_REGION( 0x080000*2 ) /* sprites */
	ROM_LOAD( "shinobi.b1", 0x00000, 0x10000, 0x611f413a )
	ROM_LOAD( "shinobi.b5", 0x10000, 0x10000, 0x5eb00fc1 )
	ROM_LOAD( "shinobi.b2", 0x20000, 0x10000, 0x3c0797c0 )
	ROM_LOAD( "shinobi.b6", 0x30000, 0x10000, 0x25307ef8 )
	ROM_LOAD( "shinobi.b3", 0x40000, 0x10000, 0xc29ac34e )
	ROM_LOAD( "shinobi.b7", 0x50000, 0x10000, 0x04a437f8 )
	ROM_LOAD( "shinobi.b4", 0x60000, 0x10000, 0x41f41063 )
	ROM_LOAD( "shinobi.b8", 0x70000, 0x10000, 0xb6e1fd72 )

	ROM_REGION( 0x10000 ) /* sound CPU */
	ROM_LOAD( "shinobi.a7", 0x0000, 0x8000, 0x2457a7cf )
ROM_END

/***************************************************************************/

static int shinobi_skip(int offset)
{
	if (cpu_getpc()==0x32e0) {cpu_spinuntil_int(); return 1<<8;}

	return READ_WORD(&sys16_workingram[0xf01c]);
}

static struct MemoryReadAddress shinobi_readmem[] =
{
	{ 0xc41002, 0xc41003, io_player1_r },
	{ 0xc41006, 0xc41007, io_player2_r },
	{ 0xc41000, 0xc41001, io_service_r },
	{ 0xc42002, 0xc42003, io_dip1_r },
	{ 0xc42000, 0xc42001, io_dip2_r },

	{ 0x410000, 0x410fff, MRA_TEXTRAM },
	{ 0x400000, 0x40ffff, MRA_TILERAM },
	{ 0x440000, 0x440fff, MRA_SPRITERAM },
	{ 0x840000, 0x840fff, MRA_PALETTERAM },

	{ 0xfff01c, 0xfff01d, shinobi_skip },

	{ 0xff0000, 0xffffff, MRA_WORKINGRAM },
	{ 0x000000, 0x03ffff, MRA_ROM },
	{-1}
};

static struct MemoryWriteAddress shinobi_writemem[] =
{
	{ 0x000000, 0x03ffff, MWA_ROM },
	{ 0xfe0006, 0xfe0007, sound_command_w },
	{ 0x410000, 0x410fff, MWA_TEXTRAM },
	{ 0x400000, 0x40ffff, MWA_TILERAM },
	{ 0x440000, 0x44ffff, MWA_SPRITERAM },
	{ 0x840000, 0x84ffff, MWA_PALETTERAM },
	{ 0xff0000, 0xffffff, MWA_WORKINGRAM },
	{-1}
};

/***************************************************************************/

void shinobi_update_proc( void ){
	sys16_fg_scrollx = READ_WORD( &sys16_textram[0x0e98] );
	sys16_bg_scrollx = READ_WORD( &sys16_textram[0x0e9a] );
	sys16_fg_scrolly = READ_WORD( &sys16_textram[0x0e90] );
	sys16_bg_scrolly = READ_WORD( &sys16_textram[0x0e92] );

	set_fg_page( READ_WORD( &sys16_textram[0x0e80] ) );
	set_bg_page( READ_WORD( &sys16_textram[0x0e82] ) );

	set_refresh( READ_WORD( &sys16_workingram[0xf018] )>>8 );
}

void shinobi_init_machine( void ){
	static int bank[16] = { 0,0,0,0,0,0,0,6,0,0,0,4,0,2,0,0 };
	sys16_obj_bank = bank;
	sys16_update_proc = shinobi_update_proc;

}

void shinobi_sprite_decode( void ){
	sys16_sprite_decode( 4,0x20000 );
}

/***************************************************************************/



INPUT_PORTS_START( shinobi_input_ports )
	SYS16_JOY1
	SYS16_JOY2
	SYS16_SERVICE
	SYS16_COINAGE
	SYS16_OPTIONS
INPUT_PORTS_END

/***************************************************************************/

MACHINE_DRIVER( shinobi_machine_driver, \
	shinobi_readmem,shinobi_writemem,shinobi_init_machine, gfx1 )

struct GameDriver shinobi_driver =
{
	__FILE__,
	0,
	"shinobi",
	"Shinobi",
	"1987",
	"Sega",
	SYS16_CREDITS,
	0,
	&shinobi_machine_driver,
	0,
	shinobi_rom,
	shinobi_sprite_decode, 0,
	0,
	0,
	shinobi_input_ports,
	0, 0, 0,
	ORIENTATION_DEFAULT,
	0, 0
};

/***************************************************************************/

ROM_START( tetrisbl_rom )
	ROM_REGION( 0x020000 ) /* 68000 code */
	ROM_LOAD_ODD ( "rom1.bin", 0x000000, 0x10000, 0x1e912131 )
	ROM_LOAD_EVEN( "rom2.bin", 0x000000, 0x10000, 0x4d165c38 )

	ROM_REGION( 0x30000 ) /* tiles */
	ROM_LOAD( "scr01.rom", 0x00000, 0x10000, 0x62640221 )
	ROM_LOAD( "scr02.rom", 0x10000, 0x10000, 0x9abd183b )
	ROM_LOAD( "scr03.rom", 0x20000, 0x10000, 0x2495fd4e )

	ROM_REGION( 0x020000*2 ) /* sprites */
	ROM_LOAD( "obj0-o.rom", 0x00000, 0x10000, 0x2fb38880 )
	ROM_LOAD( "obj0-e.rom", 0x10000, 0x10000, 0xd6a02cba )

	ROM_REGION( 0x10000 ) /* sound CPU */
	ROM_LOAD( "S-PROG.ROM", 0x0000, 0x8000, 0xbd9ba01b )
ROM_END

/***************************************************************************/

static struct MemoryReadAddress tetrisbl_readmem[] =
{
	{ 0xc41002, 0xc41003, io_player1_r },
	{ 0xc41006, 0xc41007, io_player2_r },
	{ 0xc41000, 0xc41001, io_service_r },
	{ 0xc42002, 0xc42003, io_dip1_r },
	{ 0xc42000, 0xc42001, io_dip2_r },

	{ 0x400000, 0x40ffff, MRA_TILERAM },
	{ 0x410000, 0x41ffff, MRA_TEXTRAM },
	{ 0x440000, 0x440fff, MRA_SPRITERAM },
	{ 0x840000, 0x840fff, MRA_PALETTERAM },
	{ 0xff0000, 0xffffff, MRA_WORKINGRAM },
	{ 0x000000, 0x01ffff, MRA_ROM },
	{-1}
};

static struct MemoryWriteAddress tetrisbl_writemem[] =
{
	{ 0x000000, 0x01ffff, MWA_ROM },
	{ 0x400000, 0x40ffff, MWA_TILERAM },
	{ 0x410000, 0x41ffff, MWA_TEXTRAM },
	{ 0x440000, 0x44ffff, MWA_SPRITERAM },
	{ 0x840000, 0x84ffff, MWA_PALETTERAM },
	{ 0xc42006, 0xc42007, sound_command_w },
	{ 0xff0000, 0xffffff, MWA_WORKINGRAM },
	{-1}
};
/***************************************************************************/

void tetrisbl_update_proc( void ){
	sys16_fg_scrollx = READ_WORD( &sys16_textram[0x0e98] );
	sys16_bg_scrollx = READ_WORD( &sys16_textram[0x0e9a] );
	sys16_fg_scrolly = READ_WORD( &sys16_textram[0x0e90] );
	sys16_bg_scrolly = READ_WORD( &sys16_textram[0x0e92] );

	set_fg_page( READ_WORD( &sys16_textram[0x8038] ) );
	set_bg_page( READ_WORD( &sys16_textram[0x8028] ) );

}

void tetrisbl_init_machine( void ){
	static int bank[16] = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
	sys16_obj_bank = bank;

	patch_code( 0xba6, 0x4e );
	patch_code( 0xba7, 0x71 );

	sys16_sprxoffset = -0x40;
	sys16_update_proc = tetrisbl_update_proc;
}

void tetrisbl_sprite_decode( void ){
	sys16_sprite_decode( 1,0x20000 );
}
/***************************************************************************/

INPUT_PORTS_START( tetrisbl_input_ports )
	SYS16_JOY1
	SYS16_JOY2
	SYS16_SERVICE
	SYS16_COINAGE /* unconfirmed */

	PORT_START	/* DSW1 */
		PORT_DIPNAME( 0x01, 0x01, "Cabinet?", IP_KEY_NONE )
		PORT_DIPSETTING(    0x01, "Upright")
		PORT_DIPSETTING(    0x00, "Cocktail")
		PORT_DIPNAME( 0x02, 0x02, "Demo Sounds", IP_KEY_NONE )
		PORT_DIPSETTING(    0x02, "Off" )
		PORT_DIPSETTING(    0x00, "On" )
		PORT_DIPNAME( 0x0c, 0x0c, "Lives", IP_KEY_NONE )
		PORT_DIPSETTING(    0x0c, "3" )
		PORT_DIPSETTING(    0x08, "2" )
		PORT_DIPSETTING(    0x04, "5" )
		PORT_DIPSETTING(    0x00, "FREE" )
		PORT_DIPNAME( 0x30, 0x30, "Difficulty", IP_KEY_NONE )
		PORT_DIPSETTING(    0x30, "Normal" )
		PORT_DIPSETTING(    0x20, "Easy" )
		PORT_DIPSETTING(    0x10, "Hard" )
		PORT_DIPSETTING(    0x00, "Hardest" )
		PORT_DIPNAME( 0x40, 0x40, "Bullets Speed", IP_KEY_NONE )
		PORT_DIPSETTING(    0x40, "Slow" )
		PORT_DIPSETTING(    0x00, "Fast" )
		PORT_DIPNAME( 0x80, 0x80, "Language", IP_KEY_NONE )
		PORT_DIPSETTING(    0x80, "Japanese" )
	PORT_DIPSETTING(    0x00, "English" )
INPUT_PORTS_END

/***************************************************************************/

MACHINE_DRIVER( tetrisbl_machine_driver, \
	tetrisbl_readmem,tetrisbl_writemem,tetrisbl_init_machine, gfx1 )

struct GameDriver tetrisbl_driver =
{
	__FILE__,
	0,
	"tetrisbl",
	"Tetris (Sega bootleg)",
	"1987",
	"bootleg",
	SYS16_CREDITS,
	0,
	&tetrisbl_machine_driver,
	0,
	tetrisbl_rom,
	tetrisbl_sprite_decode, 0,
	0,
	0,
	tetrisbl_input_ports,
	0, 0, 0,
	ORIENTATION_DEFAULT,
	0, 0
};

/***************************************************************************/

ROM_START( wb3bl_rom )
	ROM_REGION( 0x040000 ) /* 68000 code */
	ROM_LOAD_ODD ( "wb3_05", 0x000000, 0x10000, 0x196e17ee )
	ROM_LOAD_EVEN( "wb3_03", 0x000000, 0x10000, 0x0019ab3b )
	ROM_LOAD_ODD ( "wb3_04", 0x020000, 0x10000, 0x565d5035 )
	ROM_LOAD_EVEN( "wb3_02", 0x020000, 0x10000, 0xc87350cb )

	ROM_REGION( 0x30000 ) /* tiles */
	ROM_LOAD( "wb3_14", 0x00000, 0x10000, 0xd3f20bca )
	ROM_LOAD( "wb3_15", 0x10000, 0x10000, 0x96ff9d52 )
	ROM_LOAD( "wb3_16", 0x20000, 0x10000, 0xafaf0d31 )

	ROM_REGION( 0x080000*2 ) /* sprites */
	ROM_LOAD( "wb3_12", 0x000000, 0x010000, 0x4891e7bb )
	ROM_LOAD( "wb3_06", 0x010000, 0x010000, 0xe645902c )
	ROM_LOAD( "wb3_13", 0x020000, 0x010000, 0x8409a243 )
	ROM_LOAD( "wb3_07", 0x030000, 0x010000, 0xe774ec2c )
	ROM_LOAD( "wb3_10", 0x040000, 0x010000, 0xaeeecfca )
	ROM_LOAD( "wb3_08", 0x050000, 0x010000, 0x615e4927 )
	ROM_LOAD( "wb3_11", 0x060000, 0x010000, 0x5c2f0d90 )
	ROM_LOAD( "wb3_09", 0x070000, 0x010000, 0x0cd59d6e )

	ROM_REGION( 0x10000 ) /* sound CPU */
	ROM_LOAD( "a07.bin", 0x0000, 0x8000, 0x0bb901bb )
ROM_END

/***************************************************************************/

static struct MemoryReadAddress wb3bl_readmem[] =
{
	{ 0xc41002, 0xc41003, io_player1_r },
	{ 0xc41006, 0xc41007, io_player2_r },
	{ 0xc41000, 0xc41001, io_service_r },
	{ 0xc42002, 0xc42003, io_dip1_r },
	{ 0xc42000, 0xc42001, io_dip2_r },

	{ 0x3f0000, 0x3fffff, MRA_EXTRAM },
	{ 0x400000, 0x40ffff, MRA_TILERAM },
	{ 0x410000, 0x41ffff, MRA_TEXTRAM },
	{ 0x440000, 0x44ffff, MRA_SPRITERAM },
	{ 0x840000, 0x84ffff, MRA_PALETTERAM },
	{ 0xdf0000, 0xdfffff, MRA_EXTRAM3 },
	{ 0xff0000, 0xffffff, MRA_WORKINGRAM },
	{ 0x000000, 0x03ffff, MRA_ROM },
	{-1}
};

static struct MemoryWriteAddress wb3bl_writemem[] =
{
	{ 0x000000, 0x03ffff, MWA_ROM },
	{ 0x3f0000, 0x3fffff, MWA_EXTRAM },
	{ 0x400000, 0x40ffff, MWA_TILERAM },
	{ 0x410000, 0x41ffff, MWA_TEXTRAM },
	{ 0x440000, 0x44ffff, MWA_SPRITERAM },
	{ 0x840000, 0x84ffff, MWA_PALETTERAM },
	{ 0xc40000, 0xc4ffff, MWA_EXTRAM2 },
	{ 0xdf0000, 0xdfffff, MWA_EXTRAM3 },
	{ 0xfe0006, 0xfe0007, sound_command_w },
	{ 0xff0000, 0xffffff, MWA_WORKINGRAM },
	{-1}
};
/***************************************************************************/

void wb3bl_update_proc( void ){
	sys16_fg_scrollx = READ_WORD( &sys16_workingram[0xc030] );
	sys16_bg_scrollx = READ_WORD( &sys16_workingram[0xc038] );
	sys16_fg_scrolly = READ_WORD( &sys16_workingram[0xc032] );
	sys16_bg_scrolly = READ_WORD( &sys16_workingram[0xc03c] );

	set_fg_page( READ_WORD( &sys16_textram[0x0ff6] ) );
	set_bg_page( READ_WORD( &sys16_textram[0x0ff4] ) );
	set_refresh( READ_WORD( &sys16_extraram2[0] ) );
}

void wb3bl_init_machine( void ){
	static int bank[16] = {4,0,2,0,6,0,0,0x06,0,0,0,0x04,0,0x02,0,0};
	sys16_obj_bank = bank;

	patch_code( 0x17058, 0x4e );
	patch_code( 0x17059, 0xb9 );
	patch_code( 0x1705a, 0x00 );
	patch_code( 0x1705b, 0x00 );
	patch_code( 0x1705c, 0x09 );
	patch_code( 0x1705d, 0xdc );
	patch_code( 0x1705e, 0x4e );
	patch_code( 0x1705f, 0xf9 );
	patch_code( 0x17060, 0x00 );
	patch_code( 0x17061, 0x01 );
	patch_code( 0x17062, 0x70 );
	patch_code( 0x17063, 0xe0 );
	patch_code( 0x1a3a, 0x31 );
	patch_code( 0x1a3b, 0x7c );
	patch_code( 0x1a3c, 0x80 );
	patch_code( 0x1a3d, 0x00 );
	patch_code( 0x23df8, 0x14 );
	patch_code( 0x23df9, 0x41 );
	patch_code( 0x23dfa, 0x10 );
	patch_code( 0x23dfd, 0x14 );
	patch_code( 0x23dff, 0x1c );

	sys16_update_proc = wb3bl_update_proc;
}

void wb3bl_sprite_decode (void)
{
	int i;

	/* invert the graphics bits on the tiles */
	for (i = 0; i < 0x30000; i++)
		Machine->memory_region[1][i] ^= 0xff;

	sys16_sprite_decode( 4,0x20000 );
}

/***************************************************************************/

INPUT_PORTS_START( wb3bl_input_ports )
	SYS16_JOY1
	SYS16_JOY2
	SYS16_SERVICE
	SYS16_COINAGE
	SYS16_OPTIONS
INPUT_PORTS_END

/***************************************************************************/

MACHINE_DRIVER( wb3bl_machine_driver, \
	wb3bl_readmem,wb3bl_writemem,wb3bl_init_machine, gfx1 )

struct GameDriver wb3bl_driver =
{
	__FILE__,
	0,
	"wb3bl",
	"Wonder Boy Monster Lair (bootleg)",
	"1988",
	"bootleg",
	SYS16_CREDITS,
	0,
	&wb3bl_machine_driver,
	0,
	wb3bl_rom,
	wb3bl_sprite_decode, 0,
	0,
	0,
	wb3bl_input_ports,
	0, 0, 0,
	ORIENTATION_DEFAULT,
	0, 0
};

/***************************************************************************/

int is_system16_driver(const struct GameDriver *drv)
{
	return (
		(drv->driver_init== aliensyn_init_machine) ||
		(drv->driver_init== altbeast_init_machine) ||
		(drv->driver_init== goldnaxe_init_machine) ||
		(drv->driver_init== passshtb_init_machine) ||
		(drv->driver_init== sdi_init_machine) ||
		(drv->driver_init== shinobi_init_machine) ||
		(drv->driver_init== tetrisbl_init_machine) ||
		(drv->driver_init== wb3bl_init_machine)
	       );
}
